	list p=16f628a
	#include <p16f628a.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC16F628A
; Clock frequency: 9.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
L0002:
; 1: Define CONF_WORD = 0x3f42 'set config bits
; 2: 
; 3:  'IR gate
; 4:  'By Peter Giling
; 5:  'PCboard = MGV133
; 6: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 7: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 8: TRISA = %111100
	BSF STATUS,RP0
	MOVLW 0x3C
	MOVWF 0x05
; 9: TRISB = %00001011 'high nibble = output
	MOVLW 0x0B
	MOVWF 0x06
; 10: PORTB = 255 'all outputs high
	BCF STATUS,RP0
	MOVLW 0xFF
	MOVWF 0x06
; 11: Dim number_out As Byte
;       The address of 'number_out' is 0x2C
	number_out EQU 0x2C
; 12: Dim number_in As Byte
;       The address of 'number_in' is 0x2D
	number_in EQU 0x2D
; 13: Dim valid_number As Byte
;       The address of 'valid_number' is 0x2E
	valid_number EQU 0x2E
; 14: number_out = 33
	MOVLW 0x21
	MOVWF 0x2C
; 15: PWMon 1, 9 'set to 36 kHz output at portb.3
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BCF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 16: PWMduty 1, 127 'half duty cycle
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x20
	MOVWF CCPR1L
; 17: loop: 
L0001:
; 18: 
; 19: If PORTB.1 = 1 Then
	BTFSS 0x06,1
	GOTO L0003
; 20: If valid_number < 5 Then
	MOVLW 0x05
	SUBWF 0x2E,W
	BTFSC STATUS,C
	GOTO L0004
; 21: valid_number = valid_number + 1
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 22: Else
	GOTO L0005
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 23: PORTB.4 = 0 'green led on
	BCF 0x06,4
; 24: PORTB.5 = 1 'red led off
	BSF 0x06,5
; 25: PORTB.7 = 0 'output low
	BCF 0x06,7
; 26: Endif
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 27: Else '*                     not valid
	GOTO L0006
L0003:	MOVLW 0x1F
	ANDWF STATUS,F
; 28: If valid_number > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0007
; 29: valid_number = valid_number - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 30: Else
	GOTO L0008
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 31: PORTB.4 = 1 'green led off
	BSF 0x06,4
; 32: PORTB.5 = 0 'red led on
	BCF 0x06,5
; 33: PORTB.7 = 1 'output High
	BSF 0x06,7
; 34: Endif
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 35: Endif
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 36: WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	CALL W001
; 37: Goto loop
	GOTO L0001
; 38: 
; 39: End
L0009:	GOTO L0009
; End of program
L0010:	GOTO L0010
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x2B
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F42
; End of listing
	END
